//
//  YHSelectHKPlaceListView.swift
//  galaxy
//
//  Created by edy on 2024/8/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSelectHKPlaceListView: UIView {

    static func listView() -> YHSelectHKPlaceListView {
        let view = YHSelectHKPlaceListView(frame: UIScreen.main.bounds)
        return view
    }
    
    var selectModel: YHMakeCertificatePlaceModel? = nil {
        
        didSet {
            if let selectItem = selectModel {
                for item in listArr {
                    item.isSelect =  (selectItem.id == item.id && selectItem.name == item.name)
                }
            } else {
                for item in listArr {
                    item.isSelect =  false
                }
            }
            self.tableView.reloadData()
        }
        
    }
    var selectBlock: ((YHMakeCertificatePlaceModel)->())?
    
    var listArr:[YHMakeCertificatePlaceModel] = [] {
        didSet {
            for item in listArr {
                item.isSelect = false
            }
            self.tableView.reloadData()
        }
    }
    // 底层蒙版
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var tableView: UITableView = {
        let tableView = UITableView(frame: CGRect.zero, style:.grouped)
        if #available(iOS 15.0, *) {
           tableView.sectionHeaderTopPadding = 0.0
        }
        tableView.estimatedSectionHeaderHeight = 0.1
        tableView.estimatedSectionFooterHeight = 0.1
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.bounces = false
        tableView.register(YHHKPlaceInfoCell.self, forCellReuseIdentifier: YHHKPlaceInfoCell.cellReuseIdentifier)
        tableView.delegate = self
        tableView.dataSource = self
        tableView.isScrollEnabled = false
        return tableView
    }()
    
    var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "港府办证地点选择"
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        return label
    }()
    
    var cancelBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        button.contentHorizontalAlignment = .center
        button.setTitle("取消", for: .normal)
        button.setTitleColor( UIColor.mainTextColor, for: .normal)
        return button
    }()
    
    var confirmBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        button.contentHorizontalAlignment = .center
        button.setTitle("确定", for: .normal)
        button.setTitleColor( UIColor.brandMainColor, for: .normal)
        return button
    }()
    
    var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func sure() {
        if let model = self.selectModel, !model.isEmpty() {
            selectBlock?(model)
            self.dismiss()
            return
        }
        YHHUD.flash(message: "请选择港府办证地点")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(cancelBtn)
        whiteContentView.addSubview(confirmBtn)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(tableView)
        
        cancelBtn.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
        confirmBtn.addTarget(self, action: #selector(sure), for: .touchUpInside)

        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.height.equalTo(403)
            make.left.right.bottom.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.height.equalTo(51)
            make.centerX.equalToSuperview()
        }
        
        cancelBtn.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.height.equalTo(51)
            make.width.equalTo(38)
            make.centerY.equalTo(titleLabel)
        }
        
        confirmBtn.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.height.equalTo(51)
            make.width.equalTo(38)
            make.centerY.equalTo(titleLabel)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(titleLabel.snp.bottom)
            make.height.equalTo(1)
            make.right.equalTo(-16)
        }
        
        tableView.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(12)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-34)
        }
    }
}

extension YHSelectHKPlaceListView: UITableViewDelegate, UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return listArr.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cell = tableView.dequeueReusableCell(withIdentifier: YHHKPlaceInfoCell.cellReuseIdentifier, for: indexPath) as! YHHKPlaceInfoCell
        
        if 0 <= indexPath.row && indexPath.row < listArr.count {
            let model = listArr[indexPath.row]
            cell.updateModel(model)
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        if 0 <= indexPath.row && indexPath.row < listArr.count {
            let model = listArr[indexPath.row]
            selectModel = model
            self.tableView.reloadData()
        }
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 0.1
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        return 0.1
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        let view = UIView()
        return view
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        return view
    }
}

